<?php
    use Illuminate\Support\Facades\Request;

    $pos_layout = Request::segment(1) === 'pos' &&
                 (Request::segment(2) === 'create' || Request::segment(3) === 'edit' || Request::segment(2) === 'payment');

    $currency = session('currency');
    $business = session('business');
    $theme_color = $business['theme_color'] ?? 'blue-light';
    $is_rtl = in_array(session()->get('user.language', config('app.locale')), config('constants.langs_rtl'));
    $is_mobile = isMobile();
    $is_localhost = in_array($_SERVER['REMOTE_ADDR'], ['127.0.0.1', '::1']);
    $asset_v = config('app.asset_version', 1);

    // --------- SUPER-ROBUST Supplier detection (single-file) ----------
    $u = auth()->user();
    $is_supplier_user = false;

    if ($u) {
        // 1) Spatie roles (any guard)
        $has_role = false;
        try {
            if (method_exists($u, 'getRoleNames')) {
                $roles = collect($u->getRoleNames())->map(fn($r)=>strtolower(trim($r)));
                $has_role = $roles->contains('supplier') || $roles->contains('suppliers');
            } elseif (property_exists($u, 'roles') && $u->roles) {
                $roles = collect($u->roles)->pluck('name')->map(fn($r)=>strtolower(trim($r)));
                $has_role = $roles->contains('supplier') || $roles->contains('suppliers');
            }
        } catch (\Throwable $e) {}

        // 2) Typical app flags / types
        $user_type = strtolower((string)($u->user_type ?? ''));
        $by_type = in_array($user_type, ['supplier','supplier_user','user_supplier'], true);

        // 3) Linkage hint (you previously hit an error about this)
        $by_link = !empty($u->supplier_contact_id ?? null);

        // 4) Session mirrors (some apps stash role/type in session)
        $sess = collect((array)session('user', []));
        $sess_roles = collect((array)$sess->get('roles', []))
            ->map(fn($r)=>is_array($r)?strtolower($r['name']??''):strtolower((string)$r));
        $sess_has_role = $sess_roles->contains('supplier') || $sess_roles->contains('suppliers');
        $sess_type = strtolower((string)$sess->get('user_type', ''));
        $sess_link = !empty($sess->get('supplier_contact_id', null));

        // 5) Permission pattern (read-own only)
        $perm_supplierish = false;
        try {
            $perm_supplierish = (
                ($u->can('supplier.view_own') || $u->can('purchase.view_own') || $u->can('view_own_purchase'))
                && !$u->can('supplier.view') && !$u->can('customer.view') && !$u->can('sell.view')
            );
        } catch (\Throwable $e) {}

        $is_supplier_user = $has_role || $by_type || $by_link || $sess_has_role || $sess_link || in_array($sess_type, ['supplier','supplier_user','user_supplier'], true) || $perm_supplierish;
    }
?>

<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale(), false); ?>" dir="<?php echo e($is_rtl ? 'rtl' : 'ltr', false); ?>" class="tw-bg-white tw-scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($business['name'] ?? config('app.name'), false); ?></title>

    <?php echo $__env->make('layouts.partials.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.extracss', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('css'); ?>

    <style>
        .dataTables_length { margin-top: 70px !important; height: 99px !important; }
        @media print { #scrollable-container { overflow: visible !important; height: auto !important; } }
        .small-view-side-active { display: grid !important; z-index: 1000; position: absolute; }
        .overlay { width: 100vw; height: 100vh; background: rgba(0,0,0,.8); position: fixed; top:0; left:0; display:none; z-index:20; }
        .tw-dw-btn.tw-dw-btn-xs.tw-dw-btn-outline { width: max-content; margin: 2px; }
        #scrollable-container { position: relative; }
    </style>

    
    <?php if( !$pos_layout): ?>
   
    </style>
    <?php endif; ?>
</head>
<body class="tw-font-sans tw-antialiased tw-text-gray-900 tw-bg-gray-100 <?php echo e($pos_layout ? 'hold-transition lockscreen' : 'hold-transition skin-' . $theme_color . ' sidebar-mini', false); ?> <?php echo e($is_supplier_user ? 'supplier-mode' : '', false); ?>">
    <div class="tw-flex">

        
        <script defer>
            document.addEventListener("DOMContentLoaded", () => {
                if (localStorage.getItem("upos_sidebar_collapse") === 'true') {
                    document.body.classList.add("sidebar-collapse");
                }
            });
        </script>

        
        <?php if($is_supplier_user && !$pos_layout): ?>
        <script>
        (function () {
            function nukeSidebar() {
                // Force collapsed state for any AdminLTE-like skins
                document.body.classList.add('sidebar-collapse');
                // Remove any existing sidebar elements
                document.querySelectorAll('aside.side-bar, aside.small-view-side-active, .main-sidebar, #side-bar, .small-view-button')
                    .forEach(el => { try { el.remove(); } catch(e) {} });
            }
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', nukeSidebar);
            } else {
                nukeSidebar();
            }
        })();
        </script>
        <?php endif; ?>

        
        <?php if (! ($pos_layout || $is_supplier_user)): ?>
            <?php echo $__env->make('layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if($is_localhost): ?>
            <input type="hidden" id="__is_localhost" value="true">
        <?php endif; ?>

        <!-- Currency/system info -->
        <input type="hidden" id="__code" value="<?php echo e($currency['code'] ?? '', false); ?>">
        <input type="hidden" id="__symbol" value="<?php echo e($currency['symbol'] ?? '', false); ?>">
        <input type="hidden" id="__thousand" value="<?php echo e($currency['thousand_separator'] ?? '', false); ?>">
        <input type="hidden" id="__decimal" value="<?php echo e($currency['decimal_separator'] ?? '', false); ?>">
        <input type="hidden" id="__symbol_placement" value="<?php echo e($business['currency_symbol_placement'] ?? 'before', false); ?>">
        <input type="hidden" id="__precision" value="<?php echo e($business['currency_precision'] ?? 2, false); ?>">
        <input type="hidden" id="__quantity_precision" value="<?php echo e($business['quantity_precision'] ?? 2, false); ?>">

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_export_buttons')): ?>
            <input type="hidden" id="view_export_buttons">
        <?php endif; ?>

        <?php if($is_mobile): ?>
            <input type="hidden" id="__is_mobile">
        <?php endif; ?>

        <?php if(session('status')): ?>
            <input type="hidden" id="status_span" data-status="<?php echo e(session('status.success'), false); ?>" data-msg="<?php echo e(session('status.msg'), false); ?>">
        <?php endif; ?>

        <main class="tw-flex tw-flex-col tw-flex-1 tw-h-full tw-min-w-0 tw-bg-gray-100">
            <?php if(!$pos_layout): ?>
                <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('layouts.partials.header-pos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <div id="app"><?php echo $__env->yieldContent('vue'); ?></div>

            <div class="tw-flex-1 tw-overflow-y-auto tw-h-screen" id="scrollable-container">
                <?php echo $__env->yieldContent('content'); ?>

                <?php if(!$pos_layout): ?>
                    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <?php echo $__env->make('layouts.partials.footer_pos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>

            <div class="scrolltop no-print">
                <div class="scroll icon"><i class="fas fa-angle-up"></i></div>
            </div>

            <?php if(config('constants.iraqi_selling_price_adjustment')): ?>
                <input type="hidden" id="iraqi_selling_price_adjustment">
            <?php endif; ?>

            <section class="invoice print_section" id="receipt_section"></section>
        </main>

        <?php echo $__env->make('home.todays_profit_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Audio -->
        <audio preload="none" id="success-audio">
            <source src="<?php echo e(asset('/audio/success.mp3?v=1.1'), false); ?>" type="audio/ogg">
        </audio>
        <audio preload="none" id="error-audio">
            <source src="<?php echo e(asset('/audio/error.mp3?v=1.1'), false); ?>" type="audio/ogg">
        </audio>
        <audio preload="none" id="warning-audio">
            <source src="<?php echo e(asset('/audio/warning.mp3?v=1.1'), false); ?>" type="audio/ogg">
        </audio>

        <?php if(!empty($__additional_html)): ?>
            <?php echo $__additional_html; ?>

        <?php endif; ?>

        <?php echo $__env->make('layouts.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php echo $__env->make('layouts.partials.ai_widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="modal fade view_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

        <?php if(!empty($__additional_views) && is_array($__additional_views)): ?>
            <?php $__currentLoopData = $__additional_views; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $additional_view): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if ($__env->exists($additional_view)) echo $__env->make($additional_view, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <div class="overlay tw-hidden"></div>
    </div>
</body>
</html>
<?php /**PATH /home/adminkim/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>